﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.Mappers;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.GetConsults
{
    /// <summary>
    /// Map Consult LOB to EC step.
    /// </summary>
    public class MapConsultsRequestStep : FilterBase<GetConsultsStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetConsultsStateObject state)
        {            
            try
            {
                if (state.IsHomeMobile && state.RequestMessage.ProviderLoginStationNumber == 0) throw new Exception("ProviderLoginStationNumber cannot be 0 for a Home/Mobile appointment");
                if (state.IsStoreForward && state.RequestMessage.PatientLoginStationNumber == 0) throw new Exception("PatientLoginStationNumber cannot be 0 for a Store/Forward appointment");

                if (!state.IsStoreForward && !state.IsHomeMobile && (state.RequestMessage.ProviderLoginStationNumber == 0 || state.RequestMessage.PatientLoginStationNumber == 0)) throw new Exception("Clinic and Group appointments require both Patient/Provider Station Number");

                var mapper = new GetConsultsLobEcMapper();

                if (!state.IsHomeMobile && state.RequestMessage.PatientLoginStationNumber != 0) state.PatEcRequestMessage = mapper.Map(state.RequestMessage, state.PatientRequestUniqueId, true, state.OrganizationServiceProxy);
                else Logger.Instance.Info("Skipping Patient Side mapping for GetConsults");

                if (state.RequestMessage.ProviderLoginStationNumber != 0) state.ProEcRequestMessage = mapper.Map(state.RequestMessage, state.ProviderRequestUniqueId, false, state.OrganizationServiceProxy);
                else Logger.Instance.Info("Skipping Provider Side mapping for GetConsults");
            }
            catch (Exception ex)
            {
                throw new Exception($"HealthShare Get Consults MapConsultsRequestStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}